<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('department_master', function (Blueprint $table) {
            // Change to auto-increment
            $table->id('Dept_Id'); // This creates bigint auto-increment primary key
            $table->string('Dept_Code', 5);
            $table->string('Dept_Name', 25);
            $table->string('Dept_Type', 1);
            $table->timestamps();

            // Add index for better performance
            $table->index('Dept_Code');
        });
    }

    public function down()
    {
        Schema::dropIfExists('department_master');
    }
};
