<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gr_authority_masters', function (Blueprint $table) {
            $table->id('gr_au_id'); // Primary key with custom name
            $table->string('name', 100); // Name field
            $table->string('code', 50)->unique(); // Code field with unique constraint
            $table->boolean('is_active')->default(true); // For soft delete
            $table->timestamps();

            // Add index for better performance
            $table->index(['code', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gr_authority_masters');
    }
};
