<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('fas_grant_type_master', function (Blueprint $table) {
            if (Schema::hasColumn('fas_grant_type_master', 'granting_authority')) {
                $table->dropColumn('granting_authority');
            }

            $table->unsignedBigInteger('gr_au_id')->nullable()->after('grant_name');

            $table->foreign('gr_au_id')
                  ->references('gr_au_id')
                  ->on('gr_authority_masters')
                  ->onDelete('set null')
                  ->onUpdate('cascade');

            $table->index('gr_au_id');
        });
    }

    public function down()
    {
        Schema::table('fas_grant_type_master', function (Blueprint $table) {
            $table->dropForeign(['gr_au_id']);
            $table->dropIndex(['gr_au_id']);

            $table->dropColumn('gr_au_id');

            $table->string('granting_authority', 100)->nullable()->after('grant_name');
        });
    }
};
