<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('family_info_master', function (Blueprint $table) {
            $table->id('family_id');
            $table->string('member_name', 100);
            $table->unsignedBigInteger('relation_id')->nullable();
            $table->date('dob')->nullable();
            $table->integer('mob_num')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('relation_id')
                  ->references('relation_id')
                  ->on('relationship_master')
                  ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('family_info_master');
    }
};
