<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('fas_debt_type_master', function (Blueprint $table) {
            $table->enum('dt_cate', ['Long Term', 'Short Term'])->nullable()->after('debt_name');
            $table->enum('dt_lia_type', ['Payable', 'Deposit', 'Loan'])->nullable()->after('dt_cate');
        });
    }

    public function down()
    {
        Schema::table('fas_debt_type_master', function (Blueprint $table) {
            $table->dropColumn(['dt_cate', 'dt_lia_type']);
        });
    }
};
