<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('ledger_master', function (Blueprint $table) {
            // Add Gr_Id foreign key
            $table->unsignedBigInteger('Gr_Id')->nullable()->after('Lg_Gr');
            $table->foreign('Gr_Id')->references('Gr_Id')->on('ledg_grps')->onDelete('set null');

            // Add Description field
            $table->string('Description', 255)->nullable()->after('Lg_Buk');
        });
    }

    public function down(): void
    {
        Schema::table('ledger_master', function (Blueprint $table) {
            // Drop foreign key constraint first
            $table->dropForeign(['Gr_Id']);

            // Drop columns
            $table->dropColumn('Gr_Id');
            $table->dropColumn('Description');
        });
    }
};
