<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('budget_entries', function (Blueprint $table) {
            $table->id('Budg_Id');
            $table->unsignedBigInteger('Fin_Year');
            $table->unsignedBigInteger('Dept_Id');
             $table->unsignedBigInteger('Ledg_ID');
            $table->decimal('Amount', 15, 2);
            $table->string('Status', 1)->default('A')->comment('A=Active, I=Inactive');

            $table->timestamps();

            // Foreign key constraints
            $table->foreign('Fin_Year')->references('financial_year_id')->on('financial_year_master')->onDelete('cascade');
            $table->foreign('Dept_Id')->references('id')->on('main_departments')->onDelete('cascade');
            $table->foreign('Ledg_ID')->references('Lg_Id')->on('ledger_master')->onDelete('cascade');

            // Indexes for performance
            $table->index('Fin_Year');
            $table->index('Dept_Id');
            $table->index('Ledg_ID');
            $table->index('Status');
        });
    }

    public function down()
    {
        Schema::dropIfExists('budget_entries');
    }
};
