<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBudgetLogBookTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('BudgetLogBook', function (Blueprint $table) {
            $table->bigIncrements('BL_Id');
            $table->unsignedBigInteger('Budg_Id');
            $table->string('Status', 25)->comment('Draft, Revised, Approve, Freeze');
            $table->string('previous_status', 25)->nullable();
            $table->dateTime('Date');
            $table->unsignedBigInteger('user_id')->nullable();
            $table->decimal('budget_amount', 15, 2)->default(0);
            $table->decimal('updated_amount', 15, 2)->default(0);
            $table->text('remarks')->nullable();
            $table->timestamps();

            // Indexes first
            $table->index('Budg_Id');
            $table->index('Status');
            $table->index('Date');
            $table->index(['Budg_Id', 'Status']);
            $table->index('user_id');
        });

        // Add foreign key constraints separately to ensure they're created in the right order
        Schema::table('BudgetLogBook', function (Blueprint $table) {
            // First, make sure the budget_entries table exists
            if (Schema::hasTable('budget_entries')) {
                $table->foreign('Budg_Id')
                    ->references('Budg_Id')
                    ->on('budget_entries')
                    ->onDelete('cascade');
            }

            // Then add user foreign key
            if (Schema::hasTable('users')) {
                $table->foreign('user_id')
                    ->references('id')
                    ->on('users')
                    ->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop foreign keys first
        Schema::table('BudgetLogBook', function (Blueprint $table) {
            $table->dropForeign(['Budg_Id']);
            $table->dropForeign(['user_id']);
        });

        Schema::dropIfExists('BudgetLogBook');
    }
}
