<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scheme_master', function (Blueprint $table) {
            $table->id('scheme_id');
            $table->string('scheme_code', 30)->unique();
            $table->string('scheme_name', 200);
            $table->unsignedBigInteger('department_id')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->decimal('budget', 15, 2)->nullable();
            $table->string('status', 20)->default('ACTIVE');
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Changed to reference main_departments table
            $table->foreign('department_id')
                ->references('id')  // References 'id' column in main_departments
                ->on('main_departments')  // Changed table name
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scheme_master');
    }
};
