<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inquiry_master', function (Blueprint $table) {
            $table->id('inquiry_id');
            $table->string('inquiry_no', 30)->unique();
            $table->string('citizen_name', 100)->nullable();
            $table->string('mobile', 15)->nullable();
            $table->string('subject', 200);
            $table->string('inquiry_type', 20)->nullable();
            $table->unsignedBigInteger('department_id')->nullable(); // FK for main_departments
            $table->string('status', 20)->default('OPEN');
            $table->timestamps();

            // Add foreign key constraint to main_departments
            $table->foreign('department_id')
                ->references('id')
                ->on('main_departments')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inquiry_master');
    }
};
