<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('grant_division_mapping', function (Blueprint $table) {
            $table->id('gt_dv_id');
            $table->unsignedBigInteger('grant_ty_id');
            $table->json('dept_ids')->nullable(); // JSON array for multiple departments
            $table->tinyInteger('status')->default(1);
            $table->timestamps();

            // Foreign key for grant type
            $table->foreign('grant_ty_id')
                ->references('grant_type_id')
                ->on('fas_grant_type_master')
                ->onDelete('cascade');

            // Note: We don't create foreign key for dept_ids because it's JSON array
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('grant_division_mapping');
    }
};
