<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('finan_trns', function (Blueprint $table) {
            // सिर्फ Lg_Id add करें
            $table->unsignedBigInteger('Lg_Id')->nullable()->after('Org_Id');

            // Foreign key constraint add करें
            $table->foreign('Lg_Id')->references('Lg_Id')->on('ledger_master')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('finan_trns', function (Blueprint $table) {
            // Lg_Id को हटाएं
            $table->dropForeign(['Lg_Id']);
            $table->dropColumn('Lg_Id');
        });
    }
};
