<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRefIdToBudgetEntriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('budget_entries', function (Blueprint $table) {
            // Add Ref_Id column
            $table->integer('Ref_Id')->default(0)->after('Status');

            // Add Is_Latest column
            $table->boolean('Is_Latest')->default(true)->after('Ref_Id');

            // Add index for better performance
            $table->index('Ref_Id');
            $table->index('Is_Latest');
            $table->index(['Ref_Id', 'Is_Latest']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('budget_entries', function (Blueprint $table) {
            $table->dropIndex(['Ref_Id']);
            $table->dropIndex(['Is_Latest']);
            $table->dropIndex(['Ref_Id', 'Is_Latest']);

            $table->dropColumn('Ref_Id');
            $table->dropColumn('Is_Latest');
        });
    }
}

