<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('emdbg_type_masters', function (Blueprint $table) {
            $table->id('emdbg_id');
            $table->string('emdbg_type_code', 20)->nullable();
            $table->string('emdbg_type_name')->nullable(false);
            $table->integer('percentage')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('emdbg_type_masters');
    }
};
