<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIsLatestToBudgetEntriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('budget_entries', function (Blueprint $table) {
            // Add Is_Latest column
            $table->boolean('Is_Latest')->default(true)->after('Ref_Id');

            // Add index for better performance
            $table->index('Is_Latest');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('budget_entries', function (Blueprint $table) {
            $table->dropIndex(['Is_Latest']);
            $table->dropIndex([ 'Is_Latest']);

            $table->dropColumn('Is_Latest');
        });
    }
}
