<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('fas_funds_type_master', function (Blueprint $table) {
            // Add fund_type field (string, nullable)
            $table->string('fund_type', 50)->nullable()->after('funds_name');

            // Add source_of_fund field (string, nullable)
            $table->string('source_of_fund', 50)->nullable()->after('fund_type');
        });
    }

    public function down()
    {
        Schema::table('fas_funds_type_master', function (Blueprint $table) {
            $table->dropColumn(['fund_type', 'source_of_fund']);
        });
    }
};
