<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        // First, check if table exists and drop foreign key constraints
        if (Schema::hasTable('document_library')) {
            // Only try to drop foreign key if tender_entry_master exists
            if (Schema::hasTable('tender_entry_master')) {
                Schema::table('tender_entry_master', function (Blueprint $table) {
                    // Temporarily drop the foreign key
                    $table->dropForeign(['Doc_Lib']);
                });
            }

            // Drop the existing table
            Schema::dropIfExists('document_library');
        }

        // Create new table without unique constraint
        Schema::create('document_library', function (Blueprint $table) {
            $table->id('Doc_Lib');
            $table->foreignId('Menu_Id')->constrained('function_types', 'id')->onDelete('cascade');
            $table->string('Rec_Id'); // NO UNIQUE
            $table->text('Description');
            $table->json('Doc_Upload')->nullable();
            $table->integer('Serial_No');
            $table->timestamps();

            // Indexes
            $table->index('Menu_Id');
            $table->index('Rec_Id');
            $table->index('Serial_No');
        });

        // Re-add foreign key to tender_entry_master ONLY if table exists
        if (Schema::hasTable('tender_entry_master')) {
            Schema::table('tender_entry_master', function (Blueprint $table) {
                $table->foreign('Doc_Lib')->references('Doc_Lib')->on('document_library')->onDelete('set null');
            });
        }
    }

    public function down()
    {
        // Only drop foreign key if tender_entry_master exists
        if (Schema::hasTable('tender_entry_master')) {
            Schema::table('tender_entry_master', function (Blueprint $table) {
                $table->dropForeign(['Doc_Lib']);
            });
        }

        // Drop the table
        Schema::dropIfExists('document_library');

        // Recreate old table structure (with unique constraint)
        Schema::create('document_library', function (Blueprint $table) {
            $table->id('Doc_Lib');
            $table->foreignId('Menu_Id')->constrained('function_types', 'id')->onDelete('cascade');
            $table->string('Rec_Id')->unique();
            $table->text('Description');
            $table->json('Doc_Upload')->nullable();
            $table->integer('Serial_No');
            $table->timestamps();

            $table->index('Menu_Id');
            $table->index('Serial_No');
        });

        // Re-add foreign key if tender_entry_master exists
        if (Schema::hasTable('tender_entry_master')) {
            Schema::table('tender_entry_master', function (Blueprint $table) {
                $table->foreign('Doc_Lib')->references('Doc_Lib')->on('document_library')->onDelete('set null');
            });
        }
    }
};
