<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('tender_entry_master', function (Blueprint $table) {
            $table->id('Tend_Ent_Id');
            $table->foreignId('Bra_id')->constrained('main_departments', 'id')->onDelete('cascade');

            // Fix for ledger_master foreign key
            $table->unsignedBigInteger('Lg_Id');

            // Fix for new_tender_works foreign key
            $table->unsignedBigInteger('tend_work_id');

            $table->decimal('Proposal_Amount', 15, 2);
            $table->date('Date');
            $table->longText('Description');
            $table->foreignId('Doc_Lib')->nullable()->constrained('document_library', 'Doc_Lib')->onDelete('set null');
            $table->timestamps();

            // Foreign key for ledger_master (references Lg_id)
            $table->foreign('Lg_Id')->references('Lg_id')->on('ledger_master')->onDelete('cascade');

            // Foreign key for new_tender_works (references tend_work_id)
            $table->foreign('tend_work_id')->references('tend_work_id')->on('new_tender_works')->onDelete('cascade');

            // Indexes
            $table->index('Bra_id');
            $table->index('Lg_Id');
            $table->index('tend_work_id');
            $table->index('Date');
        });
    }

    public function down()
    {
        Schema::dropIfExists('tender_entry_master');
    }
};
