<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('grant_entries', function (Blueprint $table) {
            $table->id('Grant_Id');
            $table->unsignedBigInteger('Fin_Year');
            $table->unsignedBigInteger('Dept_Id');
            $table->unsignedBigInteger('Ledg_ID');
            $table->decimal('Amount', 15, 2);
            $table->decimal('Sug_Amount', 15, 2)->nullable();
            $table->json('Beg_Doc')->nullable();
            $table->string('Status', 2)->default('D')->comment('D=Draft, R=Revised, P=Approve, F=Freeze, A=Active, I=Inactive, RR=Re-Revised, RJ=Reject, J=Justification');
            $table->unsignedBigInteger('Ref_Id')->default(0)->comment('Reference to parent entry for versioning');
            $table->boolean('Is_Latest')->default(true)->comment('Whether this is the latest version');

            $table->timestamps();

            // Foreign key constraints
            $table->foreign('Fin_Year')->references('financial_year_id')->on('financial_year_master')->onDelete('cascade');
            $table->foreign('Dept_Id')->references('id')->on('main_departments')->onDelete('cascade');
            $table->foreign('Ledg_ID')->references('Lg_Id')->on('ledger_master')->onDelete('cascade');

            // Indexes for performance
            $table->index('Fin_Year');
            $table->index('Dept_Id');
            $table->index('Ledg_ID');
            $table->index('Status');
            $table->index('Ref_Id');
            $table->index('Is_Latest');
        });
    }

    public function down()
    {
        Schema::dropIfExists('grant_entries');
    }
};
