<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('tendor_allocation', function (Blueprint $table) {
            $table->id('Tend_Alloc');

            // Make sure these match exactly with the referenced tables
            $table->unsignedBigInteger('Tend_Ent_Id');
            $table->unsignedBigInteger('SL_Id');

            $table->decimal('Gross_Amount', 15, 2);
            $table->json('Multi_Doc')->nullable();
            $table->timestamps();

            // Add indexes first (optional but good for performance)
            $table->index('Tend_Ent_Id');
            $table->index('SL_Id');
        });

        // Add foreign keys separately to ensure tables exist
        Schema::table('tendor_allocation', function (Blueprint $table) {
            $table->foreign('Tend_Ent_Id')
                  ->references('Tend_Ent_Id')
                  ->on('tender_entry_master')
                  ->onDelete('cascade');

            $table->foreign('SL_Id')
                  ->references('SL_Id')
                  ->on('subledg_master')
                  ->onDelete('restrict');
        });
    }

    public function down()
    {
        Schema::dropIfExists('tendor_allocation');
    }
};
