<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('fa_tax_type_master', function (Blueprint $table) {
            $table->unsignedBigInteger('Lg_Id')->nullable()->after('tax_type_id');

            // Add foreign key constraint
            $table->foreign('Lg_Id')
                  ->references('Lg_Id')
                  ->on('ledger_master')
                  ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fa_tax_type_master', function (Blueprint $table) {
            $table->dropForeign(['Lg_Id']);
            $table->dropColumn('Lg_Id');
        });
    }
};
