<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subledg_master', function (Blueprint $table) {
            // Statutory & Legal Details (India-focused)
            $table->string('PAN_Number', 10)->nullable()->after('SL_Status');
            $table->string('GSTIN', 15)->nullable()->after('PAN_Number');
            $table->string('GST_Exempt_Declaration', 255)->nullable()->after('GSTIN');
            $table->string('MSME_Udyam_Registration_No', 19)->nullable()->after('GST_Exempt_Declaration');
            $table->string('CIN_LLPIN', 21)->nullable()->after('MSME_Udyam_Registration_No');
            $table->string('Shop_Act_Trade_License_No', 50)->nullable()->after('CIN_LLPIN');
            $table->string('TAN', 10)->nullable()->after('Shop_Act_Trade_License_No');

            // Banking & Payment Details
            $table->string('Bank_Name', 100)->nullable()->after('TAN');
            $table->string('Branch_Name', 100)->nullable()->after('Bank_Name');
            $table->string('Account_Holder_Name', 150)->nullable()->after('Branch_Name');
            $table->string('Account_Number', 18)->nullable()->after('Account_Holder_Name');
            $table->string('IFSC_Code', 11)->nullable()->after('Account_Number');
            $table->enum('Account_Type', ['Savings', 'Current', 'OD', 'CC', 'NRI', 'Others'])->nullable()->after('IFSC_Code');
            $table->string('Cancelled_Cheque_Path', 255)->nullable()->after('Account_Type');
            $table->string('Cancelled_Cheque_Original_Name', 255)->nullable()->after('Cancelled_Cheque_Path');

            // Additional fields for verification status
            $table->boolean('PAN_Verified')->default(false)->after('PAN_Number');
            $table->boolean('GSTIN_Verified')->default(false)->after('GSTIN');
            $table->boolean('Bank_Details_Verified')->default(false)->after('Account_Type');
            $table->date('PAN_Verified_Date')->nullable()->after('PAN_Verified');
            $table->date('GSTIN_Verified_Date')->nullable()->after('GSTIN_Verified');
            $table->date('Bank_Details_Verified_Date')->nullable()->after('Bank_Details_Verified');

            // Indexes for frequently searched fields
            $table->index('PAN_Number');
            $table->index('GSTIN');
            $table->index('IFSC_Code');
            $table->index('MSME_Udyam_Registration_No');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subledg_master', function (Blueprint $table) {
            // Drop statutory & legal fields
            $table->dropColumn([
                'PAN_Number',
                'PAN_Verified',
                'PAN_Verified_Date',
                'GSTIN',
                'GSTIN_Verified',
                'GSTIN_Verified_Date',
                'GST_Exempt_Declaration',
                'MSME_Udyam_Registration_No',
                'CIN_LLPIN',
                'Shop_Act_Trade_License_No',
                'TAN'
            ]);

            // Drop banking & payment fields
            $table->dropColumn([
                'Bank_Name',
                'Branch_Name',
                'Account_Holder_Name',
                'Account_Number',
                'IFSC_Code',
                'Account_Type',
                'Cancelled_Cheque_Path',
                'Cancelled_Cheque_Original_Name',
                'Bank_Details_Verified',
                'Bank_Details_Verified_Date'
            ]);

            // Drop indexes
            $table->dropIndex(['PAN_Number']);
            $table->dropIndex(['GSTIN']);
            $table->dropIndex(['IFSC_Code']);
            $table->dropIndex(['MSME_Udyam_Registration_No']);
        });
    }
};
