<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payment_vouchers', function (Blueprint $table) {
            // payment_status enum में नए status जोड़ें
            $table->enum('payment_status', [
                'draft',
                'pending',
                'approved',
                'paid',
                'cancelled',
                'quary',
                'hod_app',       // NEW
                'hod_query',     // NEW
                'acco_app',      // NEW
                'acco_query'     // NEW
            ])->default('draft')->change();

            // नए fields जोड़ें (optional)
            if (!Schema::hasColumn('payment_vouchers', 'hod_approved_at')) {
                $table->timestamp('hod_approved_at')->nullable();
            }

            if (!Schema::hasColumn('payment_vouchers', 'hod_approved_by')) {
                $table->integer('hod_approved_by')->nullable();
            }

            if (!Schema::hasColumn('payment_vouchers', 'acco_approved_at')) {
                $table->timestamp('acco_approved_at')->nullable();
            }

            if (!Schema::hasColumn('payment_vouchers', 'acco_approved_by')) {
                $table->integer('acco_approved_by')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_vouchers', function (Blueprint $table) {
            $table->enum('payment_status', ['draft', 'pending', 'approved', 'paid', 'cancelled', 'quary'])
                  ->default('draft')
                  ->change();

            // Remove new columns if they exist
            $columns = ['hod_approved_at', 'hod_approved_by', 'acco_approved_at', 'acco_approved_by'];
            foreach ($columns as $column) {
                if (Schema::hasColumn('payment_vouchers', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
