<?php
// database/migrations/xxxx_xx_xx_create_pay_commission_masters_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayCommissionMastersTable extends Migration
{
    public function up()
    {
        Schema::create('pay_commission_masters', function (Blueprint $table) {
            $table->id('commission_id');
            $table->string('commission_name', 50);
            $table->date('effective_from');
            $table->date('effective_to')->nullable();
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('pay_commission_masters');
    }
}
