<?php
// database/migrations/xxxx_xx_xx_create_pay_band_masters_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayBandMastersTable extends Migration
{
    public function up()
    {
        Schema::create('pay_band_masters', function (Blueprint $table) {
            $table->id('pay_band_id');
            $table->unsignedBigInteger('commission_id');
            $table->string('pay_band_code', 20);
            $table->decimal('min_pay', 10, 2);
            $table->decimal('max_pay', 10, 2);
            $table->timestamps();

            $table->foreign('commission_id')
                  ->references('commission_id')
                  ->on('pay_commission_masters')
                  ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('pay_band_masters');
    }
}
