<?php
// database/migrations/xxxx_xx_xx_create_grade_pay_masters_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGradePayMastersTable extends Migration
{
    public function up()
    {
        Schema::create('grade_pay_masters', function (Blueprint $table) {
            $table->id('grade_pay_id');
            $table->unsignedBigInteger('commission_id');
            $table->decimal('grade_pay', 10, 2);
            $table->timestamps();

            $table->foreign('commission_id')
                  ->references('commission_id')
                  ->on('pay_commission_masters')
                  ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('grade_pay_masters');
    }
}
