<?php
// database/migrations/xxxx_xx_xx_create_pay_matrix_level_masters_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayMatrixLevelMastersTable extends Migration
{
    public function up()
    {
        Schema::create('pay_matrix_level_masters', function (Blueprint $table) {
            $table->id('level_id');
            $table->unsignedBigInteger('commission_id');
            $table->string('level_code', 10);
            $table->decimal('starting_basic', 10, 2);
            $table->timestamps();

            $table->foreign('commission_id')
                  ->references('commission_id')
                  ->on('pay_commission_masters')
                  ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('pay_matrix_level_masters');
    }
}
