<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPayScaleIdFkToPayMatrixLevelMastersTable extends Migration
{
    public function up()
    {
        Schema::table('pay_matrix_level_masters', function (Blueprint $table) {
            $table->unsignedBigInteger('pay_scale_id')->nullable()->after('commission_id');

            $table->foreign('pay_scale_id')
                ->references('pay_scale_id')
                ->on('pay_scale_masters')
                ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('pay_matrix_level_masters', function (Blueprint $table) {
            $table->dropForeign(['pay_scale_id']);
            $table->dropColumn('pay_scale_id');
        });
    }
}
