<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('tender_penelty', function (Blueprint $table) {
            $table->bigIncrements('tp_id');

            $table->unsignedBigInteger('SL_Id')->nullable();
            $table->unsignedBigInteger('Tend_Alloc')->nullable();

            $table->date('Date')->nullable();

            $table->string('fix_per')->nullable();          // fix / per
            $table->string('Gross_Amount')->nullable();
            $table->string('percentage')->nullable();
            $table->string('p_amount')->nullable();
            $table->string('Bill_No')->nullable();
            $table->string('Add_Deduct')->nullable();

            $table->timestamps();

            $table->foreign('SL_Id')
                  ->references('SL_Id')
                  ->on('subledg_master')
                  ->nullOnDelete();

            $table->foreign('Tend_Alloc')
                  ->references('Tend_Alloc')
                  ->on('tendor_allocation')
                  ->nullOnDelete();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tender_penelty');
    }
};
