<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('designation_menus', function (Blueprint $table) {
            $table->id();

            $table->string('title')->nullable();
            $table->string('desc')->nullable();

            // $table->unsignedBigInteger('category_id')->nullable();
            $table->unsignedBigInteger('func_id')->nullable();

            $table->string('Upgrp')->nullable();
            $table->string('Grcod')->nullable();
            $table->string('Grsrn')->nullable();
            $table->string('Grsh')->nullable();

            $table->tinyInteger('isvisible')
                ->default(1)
                ->comment('0=Inactive, 1=Active');

            $table->string('Menu_Links')->nullable();

            $table->timestamps();

            // $table->foreign('category_id')
            //     ->references('category_id')
            //     ->on('categories')
            //     ->onDelete('set null');

            $table->foreign('func_id')
                ->references('id')
                ->on('designation_menus')
                ->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('designation_menus');
    }
};
