<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('user_department_mappings', function (Blueprint $table) {
            $table->id('User_Dept_map_Id');

            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('Dept_Id')->nullable();

            $table->boolean('Status')->default(1); // 1=Active,0=Inactive

            $table->timestamps();


            $table->foreign('user_id')->references('user_id')->on('gmc_users')->onDelete('cascade');
            $table->foreign('Dept_Id')->references('id')->on('main_departments')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_department_mappings');
    }
};
