<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('department_management', function (Blueprint $table) {
            $table->unsignedBigInteger('reporting_designation_id')
                ->nullable()
                ->after('designation_id');

            $table->foreign('reporting_designation_id')
                ->references('id')
                ->on('designation_menus')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('department_management', function (Blueprint $table) {
            $table->dropForeign(['reporting_designation_id']);
            $table->dropColumn('reporting_designation_id');
        });
    }
};
