<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('role_permissions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('role_id')->nullable();
            $table->unsignedBigInteger('func_id')->nullable();

            // actions stored as JSON
            $table->json('actions')->nullable();

            $table->timestamps();

            // FK constraints
            $table->foreign('role_id')
                ->references('Role_Id')
                ->on('role_master')
                ->nullOnDelete();

            $table->foreign('func_id')
                ->references('id')
                ->on('function_types')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('role_permissions');
    }
};
