<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('functiontypestwo', function (Blueprint $table) {
            $table->id();

            $table->string('title')->nullable();
            $table->string('desc')->nullable();

            $table->string('Upgrp')->nullable();
            $table->string('Grcod')->nullable();
            $table->string('Grsrn')->nullable();
            $table->string('Grsh')->nullable();

            $table->tinyInteger('isvisible')
                ->nullable()
                ->default(1)
                ->comment('0=Inactive, 1=Active');

            $table->string('Menu_Links')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('functiontypestwo');
    }
};
